<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright ©2013 Fillip Hannisdal AKA Revan/NeoRevan/Belazor 	  # ||
|| # All Rights Reserved. 											  # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this on your server unless the files  # ||
|| # you downloaded were done so with permission.					  # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

// #############################################################################
if ($_REQUEST['action'] == 'main' OR empty($_REQUEST['action']))
{
	// Grab total files
	$files = VBDOWNLOADS::$db->fetchRow('
		SELECT COUNT(*) AS count
		FROM $dbtech_downloads_file
	');

	// Grab disk space usage
	$disk = VBDOWNLOADS::$db->fetchRow('
		SELECT SUM(filesize) AS size
		FROM $dbtech_downloads_file
	');

	// Grab monthly disk space usage
	$diskMonthly = VBDOWNLOADS::$db->fetchRow('
		SELECT SUM(filesize) AS size
		FROM $dbtech_downloads_file
		WHERE dateline >= ?
	', array(
		TIMENOW - (60 * 60 * 24 * 30)
	));

	// Grab disk space usage
	$bandwidth = VBDOWNLOADS::$db->fetchRow('
		SELECT SUM(filesize) AS size
		FROM $dbtech_downloads_downloadlog
	');

	// Grab monthly disk space usage
	$bandwidthMonthly = VBDOWNLOADS::$db->fetchRow('
		SELECT SUM(filesize) AS size
		FROM $dbtech_downloads_downloadlog
		WHERE dateline >= ?
	', array(
		TIMENOW - (60 * 60 * 24 * 30)
	));

	print_cp_header($vbphrase['dbtech_downloads_system_info']);
	print_table_start();
	print_table_header($vbphrase['dbtech_downloads_system_info'], 4);
		
	print_cells_row(array(
		$vbphrase['dbtech_downloads_system_status'],
		$vbulletin->options['dbtech_downloads_online'] == true ? $vbphrase['dbtech_downloads_system_online'] : $vbphrase['dbtech_downloads_system_offline'],
		
		$vbphrase['dbtech_downloads_system_version'],
		'<span style="font-weight: bold;">' . VBDOWNLOADS::$version . '<span>'
	), 0, 0, -5, 'top', 1, 1);

	print_cells_row(array(
		$vbphrase['dbtech_downloads_bandwidth_usage'],
		vb_number_format($bandwidth['size'], 0, true),
		
		$vbphrase['dbtech_downloads_disk_usage'],
		vb_number_format($disk['size'], 0, true)
	), 0, 0, -5, 'top', 1, 1);
	
	print_cells_row(array(
		$vbphrase['dbtech_downloads_bandwidth_usage_monthly'],
		vb_number_format($bandwidthMonthly['size'], 0, true),
		
		$vbphrase['dbtech_downloads_disk_usage_monthly'],
		vb_number_format($diskMonthly['size'], 0, true),
	), 0, 0, -5, 'top', 1, 1);
	
	print_cells_row(array(
		$vbphrase['dbtech_downloads_files'],
		vb_number_format($files['count']),
		
		$vbphrase['dbtech_downloads_max_upload_size'],
		ini_get('upload_max_filesize')
	), 0, 0, -5, 'top', 1, 1);
	
	print_cells_row(array(
		$vbphrase['dbtech_downloads_max_input_time'],
		construct_phrase($vbphrase['dbtech_downloads_x_seconds'], ini_get('max_input_time')),
		
		$vbphrase['dbtech_downloads_memory_limit'],
		ini_get('memory_limit')
	), 0, 0, -5, 'top', 1, 1);
	
	print_table_footer();
}

print_cp_footer();